#include <stdio.h>
#include <stdlib.h>

struct elemento
{
    int info;
    struct elemento *next;
};

typedef struct elemento ElementoDiLista;
typedef ElementoDiLista *ListaDiElementi;

void InserisciTesta(ListaDiElementi *lista, int elem);
void StampaLista(ListaDiElementi lis);
void RimuoiviTesta(ListaDiElementi *lista);

int main(void)
{
	printf("Ciao! Dammi una lista di elementi: quando inserirai zero, eliminerò l'ultimo elemento, se inserisci un numero negativo stamperò la lista.\n");
    
	ListaDiElementi lista = NULL;

    int valoreDaInserire;
	printf("Inserisci i valori:\n");
    while(valoreDaInserire >= 0)
    {
        scanf("%d", &valoreDaInserire);
		
        if(valoreDaInserire > 0)
        {
            InserisciTesta(&lista, valoreDaInserire);
        }
        else
        {
            if(valoreDaInserire == 0)
            {
                RimuoiviTesta(&lista);
            }
            else
            {
                StampaLista(lista);
            }
        }
    }

	return 0;
}

void InserisciTesta(ListaDiElementi *lista, int elem)
{
    ListaDiElementi aux;
    aux = malloc(sizeof(ElementoDiLista));
    aux->info = elem;
    aux->next = *lista;
    *lista = aux;
}

void StampaLista(ListaDiElementi lis)
{
	if(lis != NULL)
	{
		printf("%d->", lis->info);
		StampaLista(lis->next);
	}
	else
	{
		printf("//");
	}
}

void RimuoiviTesta(ListaDiElementi *lista)
{
    ListaDiElementi aux;
    if(*lista != NULL)
    {
        aux = *lista;
        *lista = (*lista)->next;
        free(aux);
    }
}